﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Forms;
using System.IO;

namespace Partially_Filled_Array
{
    public partial class Form1 : Form
    {
        public Form1()
        {
            InitializeComponent();
        }

        private void goButton_Click(object sender, EventArgs e)
        {
            try
            {
                // Utworzenie tablicy przechowującej elementy odczytane z pliku.
                const int SIZE = 100;
                int[] numbers = new int[SIZE];

                // Zmienna przechowująca liczbę elementów,
                // które znajdują się w tablicy.
                int count = 0;

                // Zadeklarowanie zmiennej typu StreamReader.
                StreamReader inputFile;

                // Otworzenie pliku i pobranie obiektu typu StreamReader.
                inputFile = File.OpenText("Values.txt");

                // Odczyt zawartości pliku i umieszczenie jej w tablicy aż do chwili
                // dotarcia do końca pliku lub zapełnienia tablicy.
                while (!inputFile.EndOfStream && count < numbers.Length)
                {
                    // Odczytanie następnego elementu z pliku.
                    numbers[count] = int.Parse(inputFile.ReadLine());

                    // Inkrementacja zmiennej licznika.
                    count++;
                }

                // Zamknięcie pliku.
                inputFile.Close();

                // Wyświetlenie elementów tablicy w kontrolce ListBox.
                outputListBox.Items.Add("Plik zawiera " + count +
                    " elementów:");

                for (int index = 0; index < count; index++)
                {
                    outputListBox.Items.Add(numbers[index]);
                }
            }
            catch (Exception ex)
            {
                // Wyświetlenie komunikatu błędu.
                MessageBox.Show(ex.Message);
            }
        }

        private void exitButton_Click(object sender, EventArgs e)
        {
            // Zamknięcie formularza. 
            this.Close();
        }
    }
}
